//	K ENB Evolution    
//	Initial D-N-I Separation code by --JawZ--
//	Lens Dirt Textures by --JawZ--
//	Code by Kyo
//	Complex K enblens.fx Shader v0.229.07
//	Multiple Dynamic Vars Toggle


/*==============================================================================================================
	Usefull Constants
==============================================================================================================*/

#define PI					3.1415926535897932384626433832795	


/*==============================================================================================================
 	Main Effects options : 1 to enable, 0 to disable
==============================================================================================================*/

/**
 *	* KYO ! : Let the following define enabled in my K ENB setup ! *  
 *	Might be usefull when toggling Old Detector True / False in enbseries.ini 
 */
#define ENABLE_FLIP_DAY_NIGHT_FACTOR		1


/*==============================================================================================================
	Tinting Functions in RGB
	Lens_Tinting is for Lens FX
	Lens_Tex_Tinting is for Dirt Texture
==============================================================================================================*/

#define	USE_LENS_FX_TINTING			1
#define	USE_LENS_TEX_TINTING			1


/*==============================================================================================================
	Texture Ratio Toggler
	Enable if enblensmask texture has equal width and heigth
	Disable for 1.777777777777778 ratio textures (16:9)
	Disable as well for custom ratio textures
==============================================================================================================*/

#define USE_EQUAL_RATIO_TEX			0


/*==============================================================================================================
	This enables/disables 8 reflections lenzes instead of 4
==============================================================================================================*/

#define	USE_EXTENSIVE_REFLECTIONS		1


/*==============================================================================================================
	This enables/disables Lens Dirt Texture Blurring a/ Dynamic Blur
	Probably NOT needed with good enough textures
	Dynamic works ONLY if Blur is enabled ( 1 )
 	Default Blur Amount is 1.25
	Value is actually offset of added Blur sampling
	Smaller than 1.0 will "unblur"
	Try Bokeh weights here, f.e.
==============================================================================================================*/

#define	USE_TEXTURE_BLUR			1
#define	USE_DYNAMIC_BLUR			1

#define	fBlur_Amount				1.25			// 0.707
#define	fBlur_Velocity				2222.0


/*==============================================================================================================
 	Reflections Color Filters Factors 
	Can be 1, 2, 3, 4 or 5
	1 : Fixed, original
	2 : Single
	3 : Complex
	4 : Custom Defined
	5 : Extensive Reflections
==============================================================================================================*/

#define USE_FX_COLOR_FACTORS			5

/*--------------------------------------------------------------------------------------------------------------
	Option 5 will work only if Extensive Reflections are enabled above
	Features 8 filters for 8 reflections
	Components are set in code, no parameters here
--------------------------------------------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------------------------------------------
	Option 2 : Single Multiplier for Colors Filter per Reflection
	Features 4 filters for 4 reflections
	Allows for inc/dec Filters brightness, according to defined factor
	Try Bokeh Weights here : 0.524, 0.707, 1.122, 1.282, 1.222, 1.524, and so on
	Initial filters components in R-G-B are respectively : 
	0.3, 0.4, 0.4	First
	0.2, 0.4, 0.5	Second	
 	0.5, 0.3, 0.7	Third
	0.1, 0.2, 0.7	Fourth
--------------------------------------------------------------------------------------------------------------*/

//	OVERALL
#define fFirstFilter_Factor_Day			1.122		
#define fFirstFilter_Factor_Night		1.282
#define fFirstFilter_Factor_Interior		1.122	

#define fSecondFilter_Factor_Day		1.122
#define fSecondFilter_Factor_Night		1.282
#define fSecondFilter_Factor_Interior		1.122	

#define fThirdFilter_Factor_Day			1.122		
#define fThirdFilter_Factor_Night		1.282
#define fThirdFilter_Factor_Interior		1.122		

#define fFourthFilter_Factor_Day		1.122		
#define fFourthFilter_Factor_Night		1.282
#define fFourthFilter_Factor_Interior		1.122		


/*--------------------------------------------------------------------------------------------------------------
	Option 3 : Complex Multiplier for Colors Filter per Reflection
	Features 4 filters for 4 reflections, each filter being R-G-B separated
	Allows for inc/dec Filters brightness, according to defined factor
	Allows for tweaking each filter's RGB component 
	Try Bokeh Weights here : 0.524, 0.707, 1.122, 1.282, 1.222, 1.524, and so on
	Initial filters components in R-G-B are respectively  
	0.3, 0.4, 0.4	First
	0.2, 0.4, 0.5	Second	
	0.5, 0.3, 0.7	Third
	0.1, 0.2, 0.7	Fourth
--------------------------------------------------------------------------------------------------------------*/

//	RED
#define fFirstFilter_Red_Day			1.122		
#define fFirstFilter_Red_Night			1.282
#define fFirstFilter_Red_Interior		1.282		

#define fSecondFilter_Red_Day			1.122
#define fSecondFilter_Red_Night			1.282
#define fSecondFilter_Red_Interior		1.122		

#define fThirdFilter_Red_Day			1.122		
#define fThirdFilter_Red_Night			1.282
#define fThirdFilter_Red_Interior		1.122		

#define fFourthFilter_Red_Day			1.122	
#define fFourthFilter_Red_Night			1.282
#define fFourthFilter_Red_Interior		1.282		

//	GREEN
#define fFirstFilter_Green_Day			1.122		
#define fFirstFilter_Green_Night		1.282
#define fFirstFilter_Green_Interior		1.122		

#define fSecondFilter_Green_Day			1.122
#define fSecondFilter_Green_Night		1.282
#define fSecondFilter_Green_Interior		1.122		

#define fThirdFilter_Green_Day			1.122		
#define fThirdFilter_Green_Night		1.282
#define fThirdFilter_Green_Interior		1.122		

#define fFourthFilter_Green_Day			1.122		
#define fFourthFilter_Green_Night		1.282
#define fFourthFilter_Green_Interior		1.122		

//	BLUE
#define fFirstFilter_Blue_Day			1.122		
#define fFirstFilter_Blue_Night			1.282
#define fFirstFilter_Blue_Interior		1.122		

#define fSecondFilter_Blue_Day			1.122
#define fSecondFilter_Blue_Night		1.282
#define fSecondFilter_Blue_Interior		1.122		

#define fThirdFilter_Blue_Day			1.122		
#define fThirdFilter_Blue_Night			1.282
#define fThirdFilter_Blue_Interior		1.122		

#define fFourthFilter_Blue_Day			1.122		
#define fFourthFilter_Blue_Night		1.282
#define fFourthFilter_Blue_Interior		1.122		


/*--------------------------------------------------------------------------------------------------------------
	Option 4 : Custom Defined Colors Filter per Reflection
	Allows for custom RGB components
	No multipliers, set your R-G-B components directly here
	Initial filters components in R-G-B are respectively  
	0.3, 0.4, 0.4	First
	0.2, 0.4, 0.5	Second	
	0.5, 0.3, 0.7	Third
	0.1, 0.2, 0.7	Fourth
--------------------------------------------------------------------------------------------------------------*/

//	RED
#define fFilterOne_Red_Day			0.3
#define fFilterOne_Red_Night			0.3
#define fFilterOne_Red_Interior			0.3

#define fFilterTwo_Red_Day			0.2
#define fFilterTwo_Red_Night			0.2
#define fFilterTwo_Red_Interior			0.2

#define fFilterThree_Red_Day			0.5
#define fFilterThree_Red_Night			0.5
#define fFilterThree_Red_Interior		0.5

#define fFilterFour_Red_Day			0.1
#define fFilterFour_Red_Night			0.1
#define fFilterFour_Red_Interior		0.1

//	GREEN
#define fFilterOne_Green_Day			0.4
#define fFilterOne_Green_Night			0.4
#define fFilterOne_Green_Interior		0.4

#define fFilterTwo_Green_Day			0.4
#define fFilterTwo_Green_Night			0.4
#define fFilterTwo_Green_Interior		0.4

#define fFilterThree_Green_Day			0.3
#define fFilterThree_Green_Night		0.3
#define fFilterThree_Green_Interior		0.3

#define fFilterFour_Green_Day			0.2
#define fFilterFour_Green_Night			0.2
#define fFilterFour_Green_Interior		0.2

//	BLUE
#define fFilterOne_Blue_Day			0.4
#define fFilterOne_Blue_Night			0.4
#define fFilterOne_Blue_Interior		0.4

#define fFilterTwo_Blue_Day			0.5
#define fFilterTwo_Blue_Night			0.5
#define fFilterTwo_Blue_Interior		0.5

#define fFilterThree_Blue_Day			0.7
#define fFilterThree_Blue_Night			0.7
#define fFilterThree_Blue_Interior		0.7

#define fFilterFour_Blue_Day			0.7
#define fFilterFour_Blue_Night			0.7
#define fFilterFour_Blue_Interior		0.7


/*==============================================================================================================
	Additional Lens FX Color Filters Dynamic Variations enable/disable
	Enables Dynamic Reflections variations for :
	Intensity, Red, Green and Blue amounts
	' 1 ' will dynamically increase reflections lenses Intensity
	' 2 ' will dynamically decrease reflections lenses Intensity
	R-G-B Factors are found below
==============================================================================================================*/

#define	USE_DYNAMIC_FX				1	

#define	USE_DAY_REFLECTIONS			2
#define	USE_NIGHT_REFLECTIONS			2
#define	USE_INTERIOR_REFLECTIONS		2


/*==============================================================================================================
	Additional Lens Dirt Texture knob
	Will impact opacity of dirt texture, 0.0 a/o 1.0 being neutral
	Might be usefull when switching different textures
	If using a ' crowded ' texture, you may want to decrease this value
	Setting it to 0.0 almost will make the texture hardly visible, f.e. 0.025 or so
==============================================================================================================*/

#define	fTex_Contrast_Day			0.555
#define	fTex_Contrast_Night			1.0
#define	fTex_Contrast_Interior			1.0


/*==============================================================================================================
	Additional Lens Dirt Dynamic Variations enable/disable a/ Toggle
	Can be 0, 1 or 2
	Dynamic Lens Dirt Texture variations
	Set to 1	>	will dynamically increase and back to dirt intensity value in enbseries.ini
	Set to 2	>	will dynamically decrease and back to dirt intensity value in enbseries.ini
	Velocity is Timer Factor
	Set something rather high for it
	2222.0 makes for medium velocity, f.e.
	fDirt_Factor is a multiplier/compensator for dirt intensity, 1.0 being neutral
==============================================================================================================*/

#define	USE_DYNAMIC_LENS_DIRT			1

#define	fDirt_Factor_Day			0.877
#define	fDirt_Factor_Night			1.0
#define	fDirt_Factor_Interior			1.0

#define	fDirt_Velocity_Day			2222.0
#define	fDirt_Velocity_Night			1111.0
#define	fDirt_Velocity_Interior			2333.0


/*==============================================================================================================
	Anamorphic Lens Flare and Dynamic Variations enable/disable
==============================================================================================================*/

/**
 *	Anamorphic Lens Flare
 *	Will stack upon enbbloom.fx's a/o enbeffectprepass.fx's ones
 */
#define USE_ANAMFLARE 				0


/**
 *	Allows for dynamic variations of the ALF's Tinting, component per component
 */
#define USE_DYNAMIC_ANAMFLARE 			1


/*==============================================================================================================
	Internal parameters - Anamorphic Lens Flare related variables
==============================================================================================================*/

#define fFlareLuminance_Day 				0.333				// Threshold 
#define fFlareBlur_Day 					10.0	// 14.0, 15.0		// Size of the flare
#define fFlareIntensity_Day 				0.0 				// Intensity			
#define fFlareAxis_Day					0	// Blur axis    	// [KYO : 0 is horizontal - 1 is vertical]

#define fFlareLuminance_Night				0.333			
#define fFlareBlur_Night		 		7.0				// 15.0, 14.0		
#define fFlareIntensity_Night	      			0.18				// 0.14					
#define fFlareAxis_Night				0		

#define fFlareLuminance_Interior			0.222				
#define fFlareBlur_Interior		 		6.0				// 14.0			
#define fFlareIntensity_Interior			0.17				// 0.3, 0.68 if MEB below				
#define fFlareAxis_Interior				1	

//	For Dynamics

#if (USE_DYNAMIC_ANAMFLARE == 1)

#define	fFlare_Red_Day					0.32
#define fFlare_Green_Day				0.32
#define fFlare_Blue_Day					0.32

#define	fFlare_Red_Night				0.00
#define fFlare_Green_Night				0.111
#define fFlare_Blue_Night				1.00

#define	fFlare_Red_Interior				0.00
#define fFlare_Green_Interior				0.111
#define fFlare_Blue_Interior				1.00

#define	fFlare_Red_Amplitude_Day			1.0
#define	fFlare_Green_Amplitude_Day			1.0
#define	fFlare_Blue_Amplitude_Day			1.0

#define	fFlare_Red_Amplitude_Night			1.0
#define	fFlare_Green_Amplitude_Night			1.0
#define	fFlare_Blue_Amplitude_Night			1.0

#define	fFlare_Red_Amplitude_Interior			1.0
#define	fFlare_Green_Amplitude_Interior			1.0
#define	fFlare_Blue_Amplitude_Interior			1.0

#define	fFlare_Red_Frequency_Day			1.0
#define	fFlare_Green_Frequency_Day			1.0
#define	fFlare_Blue_Frequency_Day			1.0

#define	fFlare_Red_Frequency_Night			1.0
#define	fFlare_Green_Frequency_Night			300000.0
#define	fFlare_Blue_Frequency_Night			1.0

#define	fFlare_Red_Frequency_Interior			1.0
#define	fFlare_Green_Frequency_Interior			1000.0				// 1.0
#define	fFlare_Blue_Frequency_Interior			20.0


/*==============================================================================================================
 	Lerping, I'll simplify later 
==============================================================================================================*/

#define fFlareTint_Day	float3((fFlare_Red_Day + (0.5 * sin(2 * PI * fFlare_Red_Frequency_Day * Timer.x) + 0.5) * fFlare_Red_Amplitude_Day), (fFlare_Green_Day + (0.5 * sin(2 * PI * fFlare_Green_Frequency_Day * Timer.x) + 0.5) * fFlare_Green_Amplitude_Day), (fFlare_Blue_Day + (0.5 * sin(2 * PI * fFlare_Blue_Frequency_Day * Timer.x) + 0.5) * fFlare_Blue_Amplitude_Day))
	
#define fFlareTint_Night	float3((fFlare_Red_Night + (0.5 * sin(2 * PI * fFlare_Red_Frequency_Night * Timer.x) + 0.5) * fFlare_Red_Amplitude_Night), (fFlare_Green_Night + (0.5 * sin(2 * PI * fFlare_Green_Frequency_Night * Timer.x) + 0.5) * fFlare_Green_Amplitude_Night), (fFlare_Blue_Night + (0.5 * sin(2 * PI * fFlare_Blue_Frequency_Night * Timer.x) + 0.5) * fFlare_Blue_Amplitude_Night))	

#define fFlareTint_Interior	float3((fFlare_Red_Interior + (0.5 * sin(2 * PI * fFlare_Red_Frequency_Interior * Timer.x) + 0.5) * fFlare_Red_Amplitude_Interior), (fFlare_Green_Interior + (0.5 * sin(2 * PI * fFlare_Green_Frequency_Interior * Timer.x) + 0.5) * fFlare_Green_Amplitude_Interior), (fFlare_Blue_Interior + (0.5 * sin(2 * PI * fFlare_Blue_Frequency_Interior * Timer.x) + 0.5) * fFlare_Blue_Amplitude_Interior))	
	
/*==============================================================================================================
 	End Lerping
==============================================================================================================*/

#else

//	For Statics

#define fFlareTint_Day					float3(0.32, 0.32, 0.32)	// Tint R-G-B // [0.27 low, 0.30 discreet, 0.35 strong]
#define fFlareTint_Night				float3(0.000, 0.000, 1.000)	
//#define fFlareTint_Interior				float3(0.012, 0.313, 0.588)	// Tint R-G-B	// [KYO : Medium Electric Blue]	
#define fFlareTint_Interior				float3(0.000, 0.000, 1.000)	// Tint R-G-B	// [KYO : Blue]		

#endif


/*==============================================================================================================
	Internal parameters - Texture (EnbMask) related variables
	Will work only if USE_LENS_TEX_TINTING is enabled
	fTex_Red, Green and Blue are R-G-B components for lens dirt texture
	ColorMultiplier acts as an additional opacity knob, in case R-G-B components are set too low

	fRed, Green and Blue Velocity will work only if USE_TEX_DYNAMIC_RGB is enabled
	Velocity is how fast the colour component will vary from its original value and back
	See below for settings
==============================================================================================================*/

/**
 *	Main Toggle
 */
#define	USE_TEX_DYNAMIC_RGB				1


/*-----------------------------------------------------------------------------------------------------------------------------------------
	Dynamics are OFF
							Amounts		
									
-----------------------------------------------------------------------------------------------------------------------------------------*/

#if (USE_TEX_DYNAMIC_RGB == 0)

/**
 *	Day
 */
#define fTex_Red_Day					0.2
#define fTex_Green_Day					0.925
#define fTex_Blue_Day					0.0

#define fColorMultiplier_Tex_Day			2.222	


/**
 *	Night
 */
#define fTex_Red_Night					0.2
#define fTex_Green_Night				0.2
#define fTex_Blue_Night					0.915

#define fColorMultiplier_Tex_Night			2.0


/**
 *	Interior
 */
#define fTex_Red_Interior				0.33
#define fTex_Green_Interior				0.33
#define fTex_Blue_Interior				0.33

#define fColorMultiplier_Tex_Interior			1.11111


#endif


/*-----------------------------------------------------------------------------------------------------------------------------------------
	Dynamics are ON
							Amounts		Set + for increase
									Set - for decrease
-----------------------------------------------------------------------------------------------------------------------------------------*/

#if (USE_TEX_DYNAMIC_RGB == 1)

/**
 *	Day
 */
#define	fRed_Day_Velocity				2000.0
#define	fGreen_Day_Velocity				1.0
#define	fBlue_Day_Velocity				100.0

#define fTex_Red_Day					0.6 		+ 	abs(frac(Timer.x * fRed_Day_Velocity)* 2.0 - 1.0)
#define fTex_Green_Day					0.925 		+ 	abs(frac(Timer.x * fGreen_Day_Velocity)* 2.0 - 1.0)
#define fTex_Blue_Day					0.7 		- 	abs(frac(Timer.x * fBlue_Day_Velocity)* 2.0 - 1.0)

#define fColorMultiplier_Tex_Day			2.111	


/**
 *	Night
 */
#define	fRed_Night_Velocity				1.0
#define	fGreen_Night_Velocity				2000.0
#define	fBlue_Night_Velocity				100.0

#define fTex_Red_Night					0.2 		+ 	abs(frac(Timer.x * fRed_Night_Velocity)* 2.0 - 1.0)
#define fTex_Green_Night				0.2 		+ 	abs(frac(Timer.x * fGreen_Night_Velocity)* 2.0 - 1.0) 
#define fTex_Blue_Night					0.915 		+ 	abs(frac(Timer.x * fBlue_Night_Velocity)* 2.0 - 1.0)

#define fColorMultiplier_Tex_Night			2.0


/**
 *	Interior
 */
#define	fRed_Interior_Velocity				0.1
#define	fGreen_Interior_Velocity			0.1
#define	fBlue_Interior_Velocity				0.1

#define fTex_Red_Interior				0.33 		+ 	abs(frac(Timer.x * fRed_Interior_Velocity)* 2.0 - 1.0)
#define fTex_Green_Interior				0.33 		+ 	abs(frac(Timer.x * fGreen_Interior_Velocity)* 2.0 - 1.0)
#define fTex_Blue_Interior				0.33 		+ 	abs(frac(Timer.x * fBlue_Interior_Velocity)* 2.0 - 1.0)

#define fColorMultiplier_Tex_Interior			1.11111


#endif


/*-----------------------------------------------------------------------------------------------------------------------------------------
	Don't intervene here
-----------------------------------------------------------------------------------------------------------------------------------------*/

#define fColorFilter_Tex_Day				float3(fTex_Red_Day, fTex_Green_Day, fTex_Blue_Day)
#define fColorFilter_Tex_Night				float3(fTex_Red_Night, fTex_Green_Night, fTex_Blue_Night)
#define fColorFilter_Tex_Interior			float3(fTex_Red_Interior, fTex_Green_Interior, fTex_Blue_Interior)


/*==============================================================================================================
	Internal parameters - Lens FX related variables
==============================================================================================================*/

#define fLength_Factor_Day				2.2			// Length of FX
#define fLength_Factor_Night				2.0			
#define fLength_Factor_Interior				2.4

/**
 *	Will work only if USE_LENS_FX_TINTING is enabled
 */
#define fColorFilter_Day				float3(1.0, 0.0, 0.0)	// Tint of Lens Effect in R-G-B
#define fColorMultiplier_Day				3.777	// 4.0		// Used as an additional opacity knob, to compensate R-G-B balance if components are too low

#define fColorFilter_Night				float3(0.1, 0.0, 1.0)
#define fColorMultiplier_Night				4.0

#define fColorFilter_Interior				float3(0.44, 0.44, 0.44)
#define fColorMultiplier_Interior			4.0


/*==============================================================================================================
	Internal parameters - Dynamic Lens FX related variables
 	Will work only if USE_DYNAMIC_FX is enabled (1)
 	Frequency is how fast the value will vary, Timer multiplier, set something high here
	Timer.x is 4 + hours, so we need high values for light pulsing
 	Amplitude is how much the value will vary, from its min to its max, max being defined by its Amount
	fReflections_Factor acts as a fine-tuning multiplier/compensator for intensity, 1.0 being neutral
==============================================================================================================*/

#define fReflections_Factor_Day				0.222			// Strength of FX
#define fReflections_Factor_Night			0.455			
#define fReflections_Factor_Interior			0.677

#define fLength_Factor_Day				2.2			// Length of FX
#define fLength_Factor_Night				2.0			
#define fLength_Factor_Interior				2.4

// For Lens Intensity

#define	fInt_Amplitude_Day				1.0	
#define	fInt_Frequency_Day				1.0			// 100000.0

#define	fInt_Amplitude_Night				1.0
#define	fInt_Frequency_Night				140000.0

#define	fInt_Amplitude_Interior				1.0
#define	fInt_Frequency_Interior				100000.0


// For Lens R-G-B Amounts

#define	fRed_Amount_Day					1.0	
#define	fGreen_Amount_Day				0.0
#define	fBlue_Amount_Day				0.3

#define	fRed_Amount_Night				0.1	
#define	fGreen_Amount_Night				0.9
#define	fBlue_Amount_Night				0.0

#define	fRed_Amount_Interior				0.0	
#define	fGreen_Amount_Interior				0.9
#define	fBlue_Amount_Interior				0.4

#define	fRed_Amplitude_Day				1.0
#define	fGreen_Amplitude_Day				1.0
#define	fBlue_Amplitude_Day				1.0

#define	fRed_Amplitude_Night				1.0
#define	fGreen_Amplitude_Night				1.0
#define	fBlue_Amplitude_Night				1.0

#define	fRed_Amplitude_Interior				1.0
#define	fGreen_Amplitude_Interior			1.0
#define	fBlue_Amplitude_Interior			1.0

#define	fRed_Frequency_Day				200000.0
#define	fGreen_Frequency_Day				1.0
#define	fBlue_Frequency_Day				1.0

#define	fRed_Frequency_Night				1.0
#define	fGreen_Frequency_Night				300000.0
#define	fBlue_Frequency_Night				1.0

#define	fRed_Frequency_Interior				1.0
#define	fGreen_Frequency_Interior			1.0
#define	fBlue_Frequency_Interior			20000.0


// Opacity Knob

#define fColorMultiplier_Day				3.333			// 3.777		
#define fColorMultiplier_Night				3.777
#define fColorMultiplier_Interior			4.0


/*==============================================================================================================
	Maths a/ Lerping - Dynamic Lens FX related variables	
==============================================================================================================*/

#if (USE_DAY_REFLECTIONS == 1)
#define fLensInt_Day		fReflections_Factor_Day	 + (0.5 * sin(2 * PI * fInt_Frequency_Day * Timer.x) + 0.5) * fInt_Amplitude_Day
#elif (USE_DAY_REFLECTIONS == 2)
#define fLensInt_Day		fReflections_Factor_Day	 - (0.5 * sin(2 * PI * fInt_Frequency_Day * Timer.x) + 0.5) * fInt_Amplitude_Day
#endif
#if (USE_NIGHT_REFLECTIONS == 1)
#define fLensInt_Night		fReflections_Factor_Night + (0.5 * sin(2 * PI * fInt_Frequency_Night * Timer.x) + 0.5) * fInt_Amplitude_Night
#elif (USE_NIGHT_REFLECTIONS == 2) 
#define fLensInt_Night		fReflections_Factor_Night - (0.5 * sin(2 * PI * fInt_Frequency_Night * Timer.x) + 0.5) * fInt_Amplitude_Night
#endif
#if (USE_INTERIOR_REFLECTIONS == 1)
#define fLensInt_Interior	fReflections_Factor_Interior + (0.5 * sin(2 * PI * fInt_Frequency_Interior * Timer.x) + 0.5) * fInt_Amplitude_Interior
#elif (USE_INTERIOR_REFLECTIONS == 2)
#define fLensInt_Interior	fReflections_Factor_Interior - (0.5 * sin(2 * PI * fInt_Frequency_Interior * Timer.x) + 0.5) * fInt_Amplitude_Interior
#endif

#define fColorFilter_Day	float3((fRed_Amount_Day + (0.5 * sin(2 * PI * fRed_Frequency_Day * Timer.x) + 0.5) * fRed_Amplitude_Day), (fGreen_Amount_Day + (0.5 * sin(2 * PI * fGreen_Frequency_Day * Timer.x) + 0.5) * fGreen_Amplitude_Day), (fBlue_Amount_Day + (0.5 * sin(2 * PI * fBlue_Frequency_Day * Timer.x) + 0.5) * fBlue_Amplitude_Day))

#define fColorFilter_Night	float3((fRed_Amount_Night + (0.5 * sin(2 * PI * fRed_Frequency_Night * Timer.x) + 0.5) * fRed_Amplitude_Night), (fGreen_Amount_Night + (0.5 * sin(2 * PI * fGreen_Frequency_Night * Timer.x) + 0.5) * fGreen_Amplitude_Night), (fBlue_Amount_Night + (0.5 * sin(2 * PI * fBlue_Frequency_Night * Timer.x) + 0.5) * fBlue_Amplitude_Night))

#define fColorFilter_Interior	float3((fRed_Amount_Interior + (0.5 * sin(2 * PI * fRed_Frequency_Interior * Timer.x) + 0.5) * fRed_Amplitude_Interior), (fGreen_Amount_Interior + (0.5 * sin(2 * PI * fGreen_Frequency_Interior * Timer.x) + 0.5) * fGreen_Amplitude_Interior), (fBlue_Amount_Interior + (0.5 * sin(2 * PI * fBlue_Frequency_Interior * Timer.x) + 0.5) * fBlue_Amplitude_Interior))

/*==============================================================================================================
 	End Maths a/ Lerping
==============================================================================================================*/

/*==============================================================================================================
	External parameters
==============================================================================================================*/

#if (ENABLE_FLIP_DAY_NIGHT_FACTOR == 0)
		1 - ENightDayFactor = ENightDayFactor;
#endif

//Keyboard controlled temporary variables (in some versions exists in the config file). 
//Press and hold key 1,2,3...8 together with PageUp or PageDown to modify. By default all set to 1.0
float4	tempF1; //0,1,2,3
float4	tempF2; //5,6,7,8
float4	tempF3; //9,0
//x=Width, y=1/Width, z=ScreenScaleY, w=1/ScreenScaleY
float4	ScreenSize;
//changes in range 0..1, 0 means that night time, 1 - day time
float	ENightDayFactor;
//changes 0 or 1. 0 means that exterior, 1 - interior
float	EInteriorFactor;
//x=generic timer in range 0..1, period of 16777216 ms (4.6 hours), w=frame time elapsed (in seconds)
float4	Timer;
//additional info for computations
float4	TempParameters; 
//x=reflection intensity, y=reflection power, z=dirt intensity, w=dirt power
float4	LensParameters;
//fov in degrees
float	FieldOfView;

texture2D texColor;
texture2D texMask;		// Enblensmask Texture
texture2D texBloom1;
texture2D texBloom2;
texture2D texBloom3;
texture2D texBloom4;
texture2D texBloom5;
texture2D texBloom6;
texture2D texBloom7;
texture2D texBloom8;

sampler2D SamplerColor = sampler_state
{
	Texture   = <texColor>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerMask = sampler_state
{
	Texture   = <texMask>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom1 = sampler_state
{
	Texture   = <texBloom1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom2 = sampler_state
{
	Texture   = <texBloom2>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom3 = sampler_state
{
	Texture   = <texBloom3>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom4 = sampler_state
{
	Texture   = <texBloom4>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom5 = sampler_state
{
	Texture   = <texBloom5>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom6 = sampler_state
{
	Texture   = <texBloom6>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom7 = sampler_state
{
	Texture   = <texBloom7>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

sampler2D SamplerBloom8 = sampler_state
{
	Texture   = <texBloom8>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU  = Clamp;
	AddressV  = Clamp;
	SRGBTexture=FALSE;
	MaxMipLevel=0;
	MipMapLodBias=0;
};

struct VS_OUTPUT_POST
{
	float4 vpos  : POSITION;
	float2 txcoord0 : TEXCOORD0;
};
struct VS_INPUT_POST
{
	float3 pos  : POSITION;
	float2 txcoord0 : TEXCOORD0;
};

/**
 * Bright pass - rescales sampled pixel to emboss bright enough value.
 */
float3 BrightPass(float2 tex)
{
float fFlareLuminance =lerp( lerp( fFlareLuminance_Day, fFlareLuminance_Night, 1 - ENightDayFactor ), fFlareLuminance_Interior, EInteriorFactor);

    float3 c = tex2D(SamplerBloom2, tex).rgb;
    float3 bC = max(c - float3(fFlareLuminance, fFlareLuminance, fFlareLuminance), 0.0);
    float bright = dot(bC, 1.0);
    bright = smoothstep(0.0f, 0.5, bright);
    return lerp(0.0, c, bright);
}

/**
 * Anamorphic sampling function - scales pixel coordinate
 * to stretch the image along one of the axels.
 * (http://en.wikipedia.org/wiki/Anamorphosis)
 */
float3 AnamorphicSample(int axis, float2 tex, float blur)
{
	tex = 2.0 * tex - 1.0;
	if (!axis) tex.x /= -blur;
	else tex.y /= -blur;
	tex = 0.5 * tex + 0.5;
	return BrightPass(tex);
}

/**
 * Converts pixel color to gray-scale.
 */
float GrayScale(float3 sample)
{
	return dot(sample, float3(0.3, 0.59, 0.11));
}

/**
 * Pseudo-random number generator - returns a number generated according to the provided vector.
 */
float Random(float2 co)
{
    return frac(sin(dot(co.xy, float2(12.9898, 78.233))) * 43758.5453);
}

/**
 * Timer Formulas - Reminders
 */
/**
	float timepassed=Timer.x* Value;		
	timepassed=frac(timepassed) * 2.0 - 1.0;
	timepassed=abs(timepassed);

-1.0 to 1.0
	float amplitude = 1.0;
	float frequency = 1.0;
	float Value= sin(2 * PI * frequency * Timer.x) * amplitude;

0.0 to 1.0
	float amplitude = 1.0;
	float frequency = 1.0;
	float Value = (0.5 * sin(2 * PI * frequency * Timer.x) + 0.5) * amplitude;

Dyn
	+ frac(Timer.x * Value + Timer.x)
*/

//=====================================================================================
//	Shaders Codes
//=====================================================================================
VS_OUTPUT_POST VS_Draw(VS_INPUT_POST IN)
{
	VS_OUTPUT_POST OUT;

	OUT.vpos=float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0);

	OUT.txcoord0.xy=IN.txcoord0.xy+TempParameters.xy;	//1.0/(bloomtexsize*2.0)

	return OUT;
}

//=====================================================================================
//	Anamorphic Lens Flare
//=====================================================================================
float4 PS_ProcessPass_Anamorphic(VS_OUTPUT_POST IN, float2 vPos : VPOS, uniform int axis) : COLOR
{
float fFlareBlur =lerp( lerp( fFlareBlur_Day, fFlareBlur_Night, 1 - ENightDayFactor ), fFlareBlur_Interior, EInteriorFactor);
float3 fFlareTint =lerp( lerp( fFlareTint_Day, fFlareTint_Night, 1 - ENightDayFactor ), fFlareTint_Interior, EInteriorFactor);
float fFlareIntensity =lerp( lerp( fFlareIntensity_Day, fFlareIntensity_Night, 1 - ENightDayFactor ), fFlareIntensity_Interior, EInteriorFactor);

float fFlare_Red_Amplitude =lerp( lerp( fFlare_Red_Amplitude_Day, fFlare_Red_Amplitude_Night, 1 - ENightDayFactor ), fFlare_Red_Amplitude_Interior, EInteriorFactor);
float fFlare_Green_Amplitude =lerp( lerp( fFlare_Green_Amplitude_Day, fFlare_Green_Amplitude_Night, 1 - ENightDayFactor ), fFlare_Green_Amplitude_Interior, EInteriorFactor);
float fFlare_Blue_Amplitude =lerp( lerp( fFlare_Blue_Amplitude_Day, fFlare_Blue_Amplitude_Night, 1 - ENightDayFactor ), fFlare_Blue_Amplitude_Interior, EInteriorFactor);

float fFlare_Red_Frequency =lerp( lerp( fFlare_Red_Frequency_Day, fFlare_Red_Frequency_Night, 1 - ENightDayFactor ), fFlare_Red_Frequency_Interior, EInteriorFactor);
float fFlare_Green_Frequency =lerp( lerp( fFlare_Green_Frequency_Day, fFlare_Green_Frequency_Night, 1 - ENightDayFactor ), fFlare_Green_Frequency_Interior, EInteriorFactor);
float fFlare_Blue_Frequency =lerp( lerp( fFlare_Blue_Frequency_Day, fFlare_Blue_Frequency_Night, 1 - ENightDayFactor ), fFlare_Blue_Frequency_Interior, EInteriorFactor);

	float4 res;
	float2 coord = IN.txcoord0.xy;
	float3 anamFlare = AnamorphicSample(axis, coord.xy, fFlareBlur) * fFlareTint;
	
	res.rgb = anamFlare * fFlareIntensity;
	res.a = 1.0;
	
	return res;
}

//=====================================================================================
//	Draw
//=====================================================================================
#if (USE_LENS_FX_TINTING == 1)
float4	PS_Draw(VS_OUTPUT_POST In, uniform float3 colorfilter, uniform float colormultiplier) : COLOR
#else
float4	PS_Draw(VS_OUTPUT_POST In) : COLOR
#endif
//=====================================================================================
//	Draw w/ No Dynamics
//=====================================================================================
#if (USE_DYNAMIC_FX == 0)
{
	float4	res=0.0;
	float2	coord;

#if (USE_EXTENSIVE_REFLECTIONS == 1)
	const float3 offset[8]=
	{
	float3(2.4, 4.0, 1.0),
	float3(1.6, 3.6, 2.0),
	float3(1.2, 1.5, 0.5),
	float3(0.8, 1.0, 1.0),
	float3(0.5, 3.0, 1.0),
	float3(0.2, 2.2, 2.0),
	float3(-0.2, 1.5, 0.75),
	float3(-0.5, 1.0, 2.0)
	};
#else
	const float3 offset[4]=
	{
	float3(1.6, 4.0, 1.0),
	float3(0.7, 0.25, 2.0),
	float3(0.3, 1.5, 0.5),
	float3(-0.5, 1.0, 1.0)
	};
#endif

#if (USE_FX_COLOR_FACTORS == 2)
	// Color filter per reflection
float fFirstFilter_Factor =lerp( lerp( fFirstFilter_Factor_Day, fFirstFilter_Factor_Night, 1 - ENightDayFactor ), fFirstFilter_Factor_Interior, EInteriorFactor);
float fSecondFilter_Factor =lerp( lerp( fSecondFilter_Factor_Day, fSecondFilter_Factor_Night, 1 - ENightDayFactor ), fSecondFilter_Factor_Interior, EInteriorFactor);
float fThirdFilter_Factor =lerp( lerp( fThirdFilter_Factor_Day, fThirdFilter_Factor_Night, 1 - ENightDayFactor ), fThirdFilter_Factor_Interior, EInteriorFactor);
float fFourthFilter_Factor =lerp( lerp( fFourthFilter_Factor_Day, fFourthFilter_Factor_Night, 1 - ENightDayFactor ), fFourthFilter_Factor_Interior, EInteriorFactor);

	const float3 factors[4]=
	{
	float3(0.3* fFirstFilter_Factor, 0.4* fFirstFilter_Factor, 0.4* fFirstFilter_Factor),
	float3(0.2* fSecondFilter_Factor, 0.4* fSecondFilter_Factor, 0.5* fSecondFilter_Factor),
	float3(0.5* fThirdFilter_Factor, 0.3* fThirdFilter_Factor, 0.7* fThirdFilter_Factor),
	float3(0.1* fFourthFilter_Factor, 0.2* fFourthFilter_Factor, 0.7* fFourthFilter_Factor)
	};

#elif (USE_FX_COLOR_FACTORS == 3)
	// Color filter per reflection
float fFirstFilter_Red =lerp( lerp( fFirstFilter_Red_Day, fFirstFilter_Red_Night, 1 - ENightDayFactor ), fFirstFilter_Red_Interior, EInteriorFactor);
float fSecondFilter_Red =lerp( lerp( fSecondFilter_Red_Day, fSecondFilter_Red_Night, 1 - ENightDayFactor ), fSecondFilter_Red_Interior, EInteriorFactor);
float fThirdFilter_Red =lerp( lerp( fThirdFilter_Red_Day, fThirdFilter_Red_Night, 1 - ENightDayFactor ), fThirdFilter_Red_Interior, EInteriorFactor);
float fFourthFilter_Red =lerp( lerp( fFourthFilter_Red_Day, fFourthFilter_Red_Night, 1 - ENightDayFactor ), fFourthFilter_Red_Interior, EInteriorFactor);

float fFirstFilter_Green =lerp( lerp( fFirstFilter_Green_Day, fFirstFilter_Green_Night, 1 - ENightDayFactor ), fFirstFilter_Green_Interior, EInteriorFactor);
float fSecondFilter_Green =lerp( lerp( fSecondFilter_Green_Day, fSecondFilter_Green_Night, 1 - ENightDayFactor ), fSecondFilter_Green_Interior, EInteriorFactor);
float fThirdFilter_Green =lerp( lerp( fThirdFilter_Green_Day, fThirdFilter_Green_Night, 1 - ENightDayFactor ), fThirdFilter_Green_Interior, EInteriorFactor);
float fFourthFilter_Green =lerp( lerp( fFourthFilter_Green_Day, fFourthFilter_Green_Night, 1 - ENightDayFactor ), fFourthFilter_Green_Interior, EInteriorFactor);

float fFirstFilter_Blue =lerp( lerp( fFirstFilter_Blue_Day, fFirstFilter_Blue_Night, 1 - ENightDayFactor ), fFirstFilter_Blue_Interior, EInteriorFactor);
float fSecondFilter_Blue =lerp( lerp( fSecondFilter_Blue_Day, fSecondFilter_Blue_Night, 1 - ENightDayFactor ), fSecondFilter_Blue_Interior, EInteriorFactor);
float fThirdFilter_Blue =lerp( lerp( fThirdFilter_Blue_Day, fThirdFilter_Blue_Night, 1 - ENightDayFactor ), fThirdFilter_Blue_Interior, EInteriorFactor);
float fFourthFilter_Blue =lerp( lerp( fFourthFilter_Blue_Day, fFourthFilter_Blue_Night, 1 - ENightDayFactor ), fFourthFilter_Blue_Interior, EInteriorFactor);

	const float3 factors[4]=
	{
	float3(0.3* fFirstFilter_Red, 0.4* fFirstFilter_Green, 0.4* fFirstFilter_Blue),
	float3(0.2* fSecondFilter_Red, 0.4* fSecondFilter_Green, 0.5* fSecondFilter_Blue),
	float3(0.5* fThirdFilter_Red, 0.3* fThirdFilter_Green, 0.7* fThirdFilter_Blue),
	float3(0.1* fFourthFilter_Red, 0.2* fFourthFilter_Green, 0.7* fFourthFilter_Blue)
	};

#elif (USE_FX_COLOR_FACTORS == 4)
	// Color filter per reflection
float fFilterOne_Red =lerp( lerp( fFilterOne_Red_Day, fFilterOne_Red_Night, 1 - ENightDayFactor ), fFilterOne_Red_Interior, EInteriorFactor);
float fFilterTwo_Red =lerp( lerp( fFilterTwo_Red_Day, fFilterTwo_Red_Night, 1 - ENightDayFactor ), fFilterTwo_Red_Interior, EInteriorFactor);
float fFilterThree_Red =lerp( lerp( fFilterThree_Red_Day, fFilterThree_Red_Night, 1 - ENightDayFactor ), fFilterThree_Red_Interior, EInteriorFactor);
float fFilterFour_Red =lerp( lerp( fFilterFour_Red_Day, fFilterFour_Red_Night, 1 - ENightDayFactor ), fFilterFour_Red_Interior, EInteriorFactor);

float fFilterOne_Green =lerp( lerp( fFilterOne_Green_Day, fFilterOne_Green_Night, 1 - ENightDayFactor ), fFilterOne_Green_Interior, EInteriorFactor);
float fFilterTwo_Green =lerp( lerp( fSecondFilter_Green_Day, fSecondFilter_Green_Night, 1 - ENightDayFactor ), fSecondFilter_Green_Interior, EInteriorFactor);
float fFilterThree_Green =lerp( lerp( fFilterThree_Green_Day, fFilterThree_Green_Night, 1 - ENightDayFactor ), fFilterThree_Green_Interior, EInteriorFactor);
float fFilterFour_Green =lerp( lerp( fFilterFour_Green_Day, fFilterFour_Green_Night, 1 - ENightDayFactor ), fFilterFour_Green_Interior, EInteriorFactor);

float fFilterOne_Blue =lerp( lerp( fFilterOne_Blue_Day, fFilterOne_Blue_Night, 1 - ENightDayFactor ), fFilterOne_Blue_Interior, EInteriorFactor);
float fFilterTwo_Blue =lerp( lerp( fFilterTwo_Blue_Day, fFilterTwo_Blue_Night, 1 - ENightDayFactor ), fFilterTwo_Blue_Interior, EInteriorFactor);
float fFilterThree_Blue =lerp( lerp( fFilterThree_Blue_Day, fFilterThree_Blue_Night, 1 - ENightDayFactor ), fFilterThree_Blue_Interior, EInteriorFactor);
float fFilterFour_Blue =lerp( lerp( fFilterFour_Blue_Day, fFilterFour_Blue_Night, 1 - ENightDayFactor ), fFilterFour_Blue_Interior, EInteriorFactor);

	const float3 factors[4]=
	{
	float3(fFilterOne_Red, fFilterOne_Green, fFilterOne_Blue),
	float3(fFilterTwo_Red, fFilterTwo_Green, fFilterTwo_Blue),
	float3(fFilterThree_Red, fFilterThree_Green, fFilterThree_Blue),
	float3(fFilterFour_Red, fFilterFour_Green, fFilterFour_Blue)
	};

#elif (USE_FX_COLOR_FACTORS == 5)
	// Color filter per reflection
	const float3 factors[8]=
	{
	float3(0.3, 0.4, 0.4),
	float3(0.2, 0.4, 0.5),
	float3(0.5, 0.3, 0.7),
	float3(0.1, 0.2, 0.7),
	float3(0.7, 0.4, 0.4),
	float3(0.2, 0.7, 0.3),
	float3(0.6, 0.3, 0.7),
	float3(0.1, 0.2, 0.9)
	};

#elif (USE_FX_COLOR_FACTORS == 1)
	// Color filter per reflection
	const float3 factors[4]=
	{
	float3(0.3, 0.4, 0.4),
	float3(0.2, 0.4, 0.5),
	float3(0.5, 0.3, 0.7),
	float3(0.1, 0.2, 0.7)
	};
#endif

#if (USE_EXTENSIVE_REFLECTIONS == 1)
	for (int i=0; i<8; i++)
#else
	for (int i=0; i<4; i++)
#endif

/**
	Later Development
	for (int i=0; i<16; i++)
	for (int i=0; i<25; i++)
*/
	{
float2	distfact=(In.txcoord0.xy-0.5);
coord.xy=offset[i].x*distfact;
float fLength_Factor =lerp( lerp( fLength_Factor_Day, fLength_Factor_Night, 1 - ENightDayFactor ), fLength_Factor_Interior, EInteriorFactor);
coord.xy*=pow(fLength_Factor*length(float2(distfact.x*ScreenSize.z,distfact.y)), offset[i].y);
coord.xy*=offset[i].z;
coord.xy=0.5-coord.xy;			
	float3	templens=tex2D(SamplerBloom2, coord.xy);
	templens=templens*factors[i];
	distfact=(coord.xy-0.5);
	distfact*=2.0;
	templens*=saturate(1.0-dot(distfact,distfact));	// Limit by uv 0..1
	float	maxlens=max(templens.x, max(templens.y, templens.z));
	float	tempnor=(maxlens/(1.0+maxlens));
	tempnor=pow(tempnor, LensParameters.y);
	templens.xyz*=tempnor;

	res.xyz+=templens;
	}
	res.xyz*=0.25 * LensParameters.x;	

float3 fColorFilter =lerp( lerp( fColorFilter_Day, fColorFilter_Night, 1 - ENightDayFactor ), fColorFilter_Interior, EInteriorFactor);
float fColorMultiplier =lerp( lerp( fColorMultiplier_Day, fColorMultiplier_Night, 1 - ENightDayFactor ), fColorMultiplier_Interior, EInteriorFactor);

#if (USE_LENS_FX_TINTING == 1)
	res.xyz*= fColorFilter * fColorMultiplier;
#endif
	// Add mask
	{
	coord=In.txcoord0.xy;

#if (USE_EQUAL_RATIO_TEX == 1)
	coord.y*=ScreenSize.w;		// Remove stretching of image
#endif


float fTex_Contrast =lerp( lerp( fTex_Contrast_Day, fTex_Contrast_Night, 1 - ENightDayFactor ), fTex_Contrast_Interior, EInteriorFactor);

	float4	mask=tex2D(SamplerMask, coord);
	float3	templens=tex2D(SamplerBloom6, In.txcoord0.xy);
	float	maxlens=max(templens.x, max(templens.y, templens.z));
	float	tempnor=(maxlens/(1.0 + maxlens));
	tempnor=pow(tempnor, (LensParameters.w/fTex_Contrast));
	templens.xyz*=tempnor * LensParameters.z;

float fDirt_Velocity =lerp( lerp( fDirt_Velocity_Day, fDirt_Velocity_Night, 1 - ENightDayFactor ), fDirt_Velocity_Interior, EInteriorFactor);
float fDirt_Factor =lerp( lerp( fDirt_Factor_Day, fDirt_Factor_Night, 1 - ENightDayFactor ), fDirt_Factor_Interior, EInteriorFactor);

	float timepassed_Dirt=Timer.x* fDirt_Velocity;		
	timepassed_Dirt=frac(timepassed_Dirt) * 2.0 - 1.0;
	timepassed_Dirt=abs(timepassed_Dirt);

#if (USE_DYNAMIC_LENS_DIRT == 1)
	templens.xyz*=tempnor * ( (LensParameters.z * fDirt_Factor) + timepassed_Dirt );
#elif (USE_DYNAMIC_LENS_DIRT == 2)
	templens.xyz*=tempnor * ( (LensParameters.z * fDirt_Factor) - timepassed_Dirt );
#elif (USE_DYNAMIC_LENS_DIRT == 0)
	templens.xyz*=tempnor * LensParameters.z;
#endif
	res.xyz+=mask.xyz * templens.xyz;
	}

	return res;
}
#endif

//=====================================================================================
//	Draw w/ Dynamics
//=====================================================================================
#if (USE_DYNAMIC_FX == 1)
{
	float4	res=0.0;
	float2	coord;

float fInt_Amplitude =lerp( lerp( fInt_Amplitude_Day, fInt_Amplitude_Night, 1 - ENightDayFactor ), fInt_Amplitude_Interior, EInteriorFactor);
float fRed_Amplitude =lerp( lerp( fRed_Amplitude_Day, fRed_Amplitude_Night, 1 - ENightDayFactor ), fRed_Amplitude_Interior, EInteriorFactor);
float fGreen_Amplitude =lerp( lerp( fGreen_Amplitude_Day, fGreen_Amplitude_Night, 1 - ENightDayFactor ), fGreen_Amplitude_Interior, EInteriorFactor);
float fBlue_Amplitude =lerp( lerp( fBlue_Amplitude_Day, fBlue_Amplitude_Night, 1 - ENightDayFactor ), fBlue_Amplitude_Interior, EInteriorFactor);

float fInt_Frequency =lerp( lerp( fInt_Frequency_Day, fInt_Frequency_Night, 1 - ENightDayFactor ), fInt_Frequency_Interior, EInteriorFactor);
float fRed_Frequency =lerp( lerp( fRed_Frequency_Day, fRed_Frequency_Night, 1 - ENightDayFactor ), fRed_Frequency_Interior, EInteriorFactor);
float fGreen_Frequency =lerp( lerp( fGreen_Frequency_Day, fGreen_Frequency_Night, 1 - ENightDayFactor ), fGreen_Frequency_Interior, EInteriorFactor);
float fBlue_Frequency =lerp( lerp( fBlue_Frequency_Day, fBlue_Frequency_Night, 1 - ENightDayFactor ), fBlue_Frequency_Interior, EInteriorFactor);

	// Deepness, curvature, inverse size

#if (USE_EXTENSIVE_REFLECTIONS == 1)
	const float3 offset[8]=
	{
	float3(2.4, 4.0, 1.0),
	float3(1.6, 3.6, 2.0),
	float3(1.2, 1.5, 0.5),
	float3(0.8, 1.0, 1.0),
	float3(0.5, 3.0, 1.0),
	float3(0.2, 2.2, 2.0),
	float3(-0.2, 1.5, 0.75),
	float3(-0.5, 1.0, 2.0)
	};
#else
	const float3 offset[4]=
	{
	float3(1.6, 4.0, 1.0),
	float3(0.7, 0.25, 2.0),
	float3(0.3, 1.5, 0.5),
	float3(-0.5, 1.0, 1.0)
	};
#endif

#if (USE_FX_COLOR_FACTORS == 2)
	// Color filter per reflection
float fFirstFilter_Factor =lerp( lerp( fFirstFilter_Factor_Day, fFirstFilter_Factor_Night, 1 - ENightDayFactor ), fFirstFilter_Factor_Interior, EInteriorFactor);
float fSecondFilter_Factor =lerp( lerp( fSecondFilter_Factor_Day, fSecondFilter_Factor_Night, 1 - ENightDayFactor ), fSecondFilter_Factor_Interior, EInteriorFactor);
float fThirdFilter_Factor =lerp( lerp( fThirdFilter_Factor_Day, fThirdFilter_Factor_Night, 1 - ENightDayFactor ), fThirdFilter_Factor_Interior, EInteriorFactor);
float fFourthFilter_Factor =lerp( lerp( fFourthFilter_Factor_Day, fFourthFilter_Factor_Night, 1 - ENightDayFactor ), fFourthFilter_Factor_Interior, EInteriorFactor);

	const float3 factors[4]=
	{
	float3(0.3* fFirstFilter_Factor, 0.4* fFirstFilter_Factor, 0.4* fFirstFilter_Factor),
	float3(0.2* fSecondFilter_Factor, 0.4* fSecondFilter_Factor, 0.5* fSecondFilter_Factor),
	float3(0.5* fThirdFilter_Factor, 0.3* fThirdFilter_Factor, 0.7* fThirdFilter_Factor),
	float3(0.1* fFourthFilter_Factor, 0.2* fFourthFilter_Factor, 0.7* fFourthFilter_Factor)
	};

#elif (USE_FX_COLOR_FACTORS == 3)
	// Color filter per reflection
float fFirstFilter_Red =lerp( lerp( fFirstFilter_Red_Day, fFirstFilter_Red_Night, 1 - ENightDayFactor ), fFirstFilter_Red_Interior, EInteriorFactor);
float fSecondFilter_Red =lerp( lerp( fSecondFilter_Red_Day, fSecondFilter_Red_Night, 1 - ENightDayFactor ), fSecondFilter_Red_Interior, EInteriorFactor);
float fThirdFilter_Red =lerp( lerp( fThirdFilter_Red_Day, fThirdFilter_Red_Night, 1 - ENightDayFactor ), fThirdFilter_Red_Interior, EInteriorFactor);
float fFourthFilter_Red =lerp( lerp( fFourthFilter_Red_Day, fFourthFilter_Red_Night, 1 - ENightDayFactor ), fFourthFilter_Red_Interior, EInteriorFactor);

float fFirstFilter_Green =lerp( lerp( fFirstFilter_Green_Day, fFirstFilter_Green_Night, 1 - ENightDayFactor ), fFirstFilter_Green_Interior, EInteriorFactor);
float fSecondFilter_Green =lerp( lerp( fSecondFilter_Green_Day, fSecondFilter_Green_Night, 1 - ENightDayFactor ), fSecondFilter_Green_Interior, EInteriorFactor);
float fThirdFilter_Green =lerp( lerp( fThirdFilter_Green_Day, fThirdFilter_Green_Night, 1 - ENightDayFactor ), fThirdFilter_Green_Interior, EInteriorFactor);
float fFourthFilter_Green =lerp( lerp( fFourthFilter_Green_Day, fFourthFilter_Green_Night, 1 - ENightDayFactor ), fFourthFilter_Green_Interior, EInteriorFactor);

float fFirstFilter_Blue =lerp( lerp( fFirstFilter_Blue_Day, fFirstFilter_Blue_Night, 1 - ENightDayFactor ), fFirstFilter_Blue_Interior, EInteriorFactor);
float fSecondFilter_Blue =lerp( lerp( fSecondFilter_Blue_Day, fSecondFilter_Blue_Night, 1 - ENightDayFactor ), fSecondFilter_Blue_Interior, EInteriorFactor);
float fThirdFilter_Blue =lerp( lerp( fThirdFilter_Blue_Day, fThirdFilter_Blue_Night, 1 - ENightDayFactor ), fThirdFilter_Blue_Interior, EInteriorFactor);
float fFourthFilter_Blue =lerp( lerp( fFourthFilter_Blue_Day, fFourthFilter_Blue_Night, 1 - ENightDayFactor ), fFourthFilter_Blue_Interior, EInteriorFactor);

	const float3 factors[4]=
	{
	float3(0.3* fFirstFilter_Red, 0.4* fFirstFilter_Green, 0.4* fFirstFilter_Blue),
	float3(0.2* fSecondFilter_Red, 0.4* fSecondFilter_Green, 0.5* fSecondFilter_Blue),
	float3(0.5* fThirdFilter_Red, 0.3* fThirdFilter_Green, 0.7* fThirdFilter_Blue),
	float3(0.1* fFourthFilter_Red, 0.2* fFourthFilter_Green, 0.7* fFourthFilter_Blue)
	};

#elif (USE_FX_COLOR_FACTORS == 4)
	// Color filter per reflection
float fFilterOne_Red =lerp( lerp( fFilterOne_Red_Day, fFilterOne_Red_Night, 1 - ENightDayFactor ), fFilterOne_Red_Interior, EInteriorFactor);
float fFilterTwo_Red =lerp( lerp( fFilterTwo_Red_Day, fFilterTwo_Red_Night, 1 - ENightDayFactor ), fFilterTwo_Red_Interior, EInteriorFactor);
float fFilterThree_Red =lerp( lerp( fFilterThree_Red_Day, fFilterThree_Red_Night, 1 - ENightDayFactor ), fFilterThree_Red_Interior, EInteriorFactor);
float fFilterFour_Red =lerp( lerp( fFilterFour_Red_Day, fFilterFour_Red_Night, 1 - ENightDayFactor ), fFilterFour_Red_Interior, EInteriorFactor);

float fFilterOne_Green =lerp( lerp( fFilterOne_Green_Day, fFilterOne_Green_Night, 1 - ENightDayFactor ), fFilterOne_Green_Interior, EInteriorFactor);
float fFilterTwo_Green =lerp( lerp( fSecondFilter_Green_Day, fSecondFilter_Green_Night, 1 - ENightDayFactor ), fSecondFilter_Green_Interior, EInteriorFactor);
float fFilterThree_Green =lerp( lerp( fFilterThree_Green_Day, fFilterThree_Green_Night, 1 - ENightDayFactor ), fFilterThree_Green_Interior, EInteriorFactor);
float fFilterFour_Green =lerp( lerp( fFilterFour_Green_Day, fFilterFour_Green_Night, 1 - ENightDayFactor ), fFilterFour_Green_Interior, EInteriorFactor);

float fFilterOne_Blue =lerp( lerp( fFilterOne_Blue_Day, fFilterOne_Blue_Night, 1 - ENightDayFactor ), fFilterOne_Blue_Interior, EInteriorFactor);
float fFilterTwo_Blue =lerp( lerp( fFilterTwo_Blue_Day, fFilterTwo_Blue_Night, 1 - ENightDayFactor ), fFilterTwo_Blue_Interior, EInteriorFactor);
float fFilterThree_Blue =lerp( lerp( fFilterThree_Blue_Day, fFilterThree_Blue_Night, 1 - ENightDayFactor ), fFilterThree_Blue_Interior, EInteriorFactor);
float fFilterFour_Blue =lerp( lerp( fFilterFour_Blue_Day, fFilterFour_Blue_Night, 1 - ENightDayFactor ), fFilterFour_Blue_Interior, EInteriorFactor);

	const float3 factors[4]=
	{
	float3(fFilterOne_Red, fFilterOne_Green, fFilterOne_Blue),
	float3(fFilterTwo_Red, fFilterTwo_Green, fFilterTwo_Blue),
	float3(fFilterThree_Red, fFilterThree_Green, fFilterThree_Blue),
	float3(fFilterFour_Red, fFilterFour_Green, fFilterFour_Blue)
	};

#elif (USE_FX_COLOR_FACTORS == 5)
	// Color filter per reflection
	const float3 factors[8]=
	{
	float3(0.3, 0.4, 0.4),
	float3(0.2, 0.4, 0.5),
	float3(0.5, 0.3, 0.7),
	float3(0.1, 0.2, 0.7),
	float3(0.7, 0.4, 0.4),
	float3(0.2, 0.7, 0.3),
	float3(0.6, 0.3, 0.7),
	float3(0.1, 0.2, 0.9)
	};

#elif (USE_FX_COLOR_FACTORS == 1)
	// Color filter per reflection
	const float3 factors[4]=
	{
	float3(0.3, 0.4, 0.4),
	float3(0.2, 0.4, 0.5),
	float3(0.5, 0.3, 0.7),
	float3(0.1, 0.2, 0.7)
	};
#endif

#if (USE_EXTENSIVE_REFLECTIONS == 1)
	for (int i=0; i<8; i++)
#else
	for (int i=0; i<4; i++)
#endif

/**
	Later Development
	for (int i=0; i<16; i++)
	for (int i=0; i<25; i++)
*/
	{
float2	distfact=(In.txcoord0.xy-0.5);
coord.xy=offset[i].x*distfact;
float fLength_Factor =lerp( lerp( fLength_Factor_Day, fLength_Factor_Night, 1 - ENightDayFactor ), fLength_Factor_Interior, EInteriorFactor);
coord.xy*=pow(fLength_Factor*length(float2(distfact.x*ScreenSize.z,distfact.y)), offset[i].y);
coord.xy*=offset[i].z;
coord.xy=0.5-coord.xy;				

	float3	templens=tex2D(SamplerBloom2, coord.xy);
	templens=templens*factors[i];
	distfact=(coord.xy-0.5);
	distfact*=2.0;
	templens*=saturate(1.0-dot(distfact,distfact));	// Limit by uv 0..1
	float	maxlens=max(templens.x, max(templens.y, templens.z));
	float	tempnor=(maxlens/(1.0+maxlens));
	tempnor=pow(tempnor, LensParameters.y);
	templens.xyz*=tempnor;

	res.xyz+=templens;
	}

float fLensInt =lerp( lerp( fLensInt_Day, fLensInt_Night, 1 - ENightDayFactor ), fLensInt_Interior, EInteriorFactor);
float3 fColorFilter =lerp( lerp( fColorFilter_Day, fColorFilter_Night, 1 - ENightDayFactor ), fColorFilter_Interior, EInteriorFactor);
float fColorMultiplier =lerp( lerp( fColorMultiplier_Day, fColorMultiplier_Night, 1 - ENightDayFactor ), fColorMultiplier_Interior, EInteriorFactor);

#if (USE_LENS_FX_TINTING == 1)
	res.xyz*= (fLensInt * 0.25) * LensParameters.x;
	res.xyz*= fColorFilter * fColorMultiplier;
#else
	res.xyz*= (fLensInt * 0.25) * LensParameters.x;
#endif

	// Add mask
	{
	coord=In.txcoord0.xy;

#if (USE_EQUAL_RATIO_TEX == 1)
	coord.y*=ScreenSize.w;		// Remove stretching of image
#endif

float fDirt_Velocity =lerp( lerp( fDirt_Velocity_Day, fDirt_Velocity_Night, 1 - ENightDayFactor ), fDirt_Velocity_Interior, EInteriorFactor);
float fDirt_Factor =lerp( lerp( fDirt_Factor_Day, fDirt_Factor_Night, 1 - ENightDayFactor ), fDirt_Factor_Interior, EInteriorFactor);
float fTex_Contrast =lerp( lerp( fTex_Contrast_Day, fTex_Contrast_Night, 1 - ENightDayFactor ), fTex_Contrast_Interior, EInteriorFactor);

	float timepassed_Dirt=Timer.x* fDirt_Velocity;		
	timepassed_Dirt=frac(timepassed_Dirt) * 2.0 - 1.0;
	timepassed_Dirt=abs(timepassed_Dirt);

	float4	mask=tex2D(SamplerMask, coord);
	float3	templens=tex2D(SamplerBloom6, In.txcoord0.xy);
	float	maxlens=max(templens.x, max(templens.y, templens.z));
	float	tempnor=(maxlens/(1.0 + maxlens));
	tempnor=pow(tempnor, (LensParameters.w/fTex_Contrast));

#if (USE_DYNAMIC_LENS_DIRT == 1)
	templens.xyz*=tempnor * ( (LensParameters.z * fDirt_Factor) + timepassed_Dirt );
#elif (USE_DYNAMIC_LENS_DIRT == 2)
	templens.xyz*=tempnor * ( (LensParameters.z * fDirt_Factor) - timepassed_Dirt );
#elif (USE_DYNAMIC_LENS_DIRT == 0)
	templens.xyz*=tempnor * LensParameters.z;
#endif
	res.xyz+=mask.xyz * templens.xyz;
	}

	return res;
}
#endif

//=====================================================================================
//	Lens PostPass
//=====================================================================================
#if (USE_LENS_TEX_TINTING == 1)
float4	PS_LensPostPass(VS_OUTPUT_POST In, uniform float3 colorfilter, uniform float colormultiplier) : COLOR
#else
float4	PS_LensPostPass(VS_OUTPUT_POST In) : COLOR
#endif
{
float3 fColorFilter_Tex =lerp( lerp( fColorFilter_Tex_Day, fColorFilter_Tex_Night, 1 - ENightDayFactor ), fColorFilter_Tex_Interior, EInteriorFactor);
float fColorMultiplier_Tex =lerp( lerp( fColorMultiplier_Tex_Day, fColorMultiplier_Tex_Night, 1 - ENightDayFactor ), fColorMultiplier_Tex_Interior, EInteriorFactor);

		float4	res=0.0;

#if (USE_TEXTURE_BLUR == 1)

 #if (USE_DYNAMIC_BLUR == 1)
	float timepassed_Blur=Timer.x* fBlur_Velocity;		
	timepassed_Blur=frac(timepassed_Blur) * 2.0 - 1.0;
	timepassed_Blur=abs(timepassed_Blur);

	const float2 offset[4]=
	{
		float2( fBlur_Amount + timepassed_Blur, fBlur_Amount + timepassed_Blur),
		float2( fBlur_Amount + timepassed_Blur,-fBlur_Amount - timepassed_Blur),
		float2(-fBlur_Amount - timepassed_Blur, fBlur_Amount + timepassed_Blur),
		float2(-fBlur_Amount - timepassed_Blur,-fBlur_Amount - timepassed_Blur)
	};

 #else
	const float2 offset[4]=
	{
		float2( fBlur_Amount, fBlur_Amount),
		float2( fBlur_Amount,-fBlur_Amount),
		float2(-fBlur_Amount, fBlur_Amount),
		float2(-fBlur_Amount,-fBlur_Amount)
	};
 #endif

	float2	screenfact=ScreenSize.y;
	screenfact.y*=ScreenSize.z;
	for (int i=0; i<4; i++)
	{
		float2	coord=offset[i].xy*screenfact.xy+In.txcoord0.xy;
		res.xyz+=tex2D(SamplerColor, coord);
	}
	res.xyz*=0.25;
	res.xyz=min(res.xyz, 32768.0);
	res.xyz=max(res.xyz, 0.0);
 #if (USE_LENS_TEX_TINTING == 1)
	res.xyz*=fColorFilter_Tex * fColorMultiplier_Tex;
 #endif
#endif

#if (USE_TEXTURE_BLUR == 0)
	res=tex2D(SamplerColor, In.txcoord0.xy);
	res.xyz=min(res.xyz, 32768.0);					
	res.xyz=max(res.xyz, 0.0);
 #if (USE_LENS_TEX_TINTING == 1)
	res.xyz*=fColorFilter_Tex * fColorMultiplier_Tex;
 #endif
#endif
	return res;
}

//=====================================================================================
//	Techniques
//=====================================================================================
// Actual computation, draw all effects to texture
technique Draw
{
    pass p0
    {
	VertexShader = compile vs_3_0 VS_Draw();
#if (USE_LENS_FX_TINTING == 1)
PixelShader  = compile ps_3_0 PS_Draw(lerp(lerp( fColorFilter_Day, fColorFilter_Night, 1 - ENightDayFactor ), fColorFilter_Interior, EInteriorFactor), lerp(lerp( fColorMultiplier_Day, fColorMultiplier_Night, 1 - ENightDayFactor ), fColorMultiplier_Interior, EInteriorFactor));
#else
	PixelShader  = compile ps_3_0 PS_Draw();
#endif

	ColorWriteEnable=ALPHA|RED|GREEN|BLUE;
	CullMode=NONE;
	AlphaBlendEnable=FALSE;
	AlphaTestEnable=FALSE;
	SeparateAlphaBlendEnable=FALSE;
	SRGBWriteEnable=FALSE;
	}
}



//Final pass, output to screen with additive blending and no alpha
technique LensPostPass
{
    pass p0
    {
	VertexShader = compile vs_3_0 VS_Draw();
#if (USE_LENS_TEX_TINTING == 1)
PixelShader  = compile ps_3_0 PS_LensPostPass(lerp(lerp(fColorFilter_Tex_Day, fColorFilter_Tex_Night, 1 - ENightDayFactor ), fColorFilter_Tex_Interior, EInteriorFactor), lerp(lerp( fColorMultiplier_Tex_Day, fColorMultiplier_Tex_Night, 1 - ENightDayFactor ), fColorMultiplier_Tex_Interior, EInteriorFactor));
#else
	PixelShader  = compile ps_3_0 PS_LensPostPass();
#endif

	AlphaBlendEnable=TRUE;
	SrcBlend=ONE;
	DestBlend=ONE;
	ColorWriteEnable=RED|GREEN|BLUE;	// Warning, no alpha output !
	CullMode=NONE;
	AlphaTestEnable=FALSE;
	SeparateAlphaBlendEnable=FALSE;
	SRGBWriteEnable=FALSE;
	}

#if (USE_ANAMFLARE == 1)
	pass p1
	{
	AlphaBlendEnable = true;
	SrcBlend = One;
	DestBlend = One;			
	PixelShader = compile ps_3_0 PS_ProcessPass_Anamorphic(lerp(lerp( fFlareAxis_Day, fFlareAxis_Night, 1 - ENightDayFactor ), fFlareAxis_Interior, EInteriorFactor));
	}
#endif

}
